/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.superplan;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import cz.insophy.inplan.planning.algorithms.RebuildPlannerUtils;
import cz.insophy.inplan.remote.common.CompletedQty;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.superplan.StartEndQtyUpdater;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Tuple;
import cz.insophy.inplan.util.problems.Problem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletedQtiesLoader {
    private static final Logger log = LoggerFactory.getLogger(CompletedQtiesLoader.class);
    private final List<CompletedQty> completedQties;
    private final Superplan superplan;
    private final List<Problem> problems;
    private final List<GeneralizedActionRequest> affectedGars;

    public CompletedQtiesLoader(Superplan superplan, List<CompletedQty> completedQties) {
        this.superplan = superplan;
        this.completedQties = completedQties;
        this.problems = Lists.newArrayList();
        this.affectedGars = Lists.newArrayList();
    }

    public void addInFixationCompleted() {
        ImmutableListMultimap<String, CompletedQty> ciMap = Multimaps.index(this.completedQties, new Function<CompletedQty, String>(){

            @Override
            public String apply(CompletedQty input) {
                return input.getGorId();
            }
        });
        long fixation = this.superplan.getFixationDate();
        Iterator<GeneralizedOrderRequest> gorIt = this.superplan.getGors().iterator();
        ArrayList<CompletedQty> completedToAdd = Lists.newArrayList();
        while (gorIt.hasNext()) {
            GeneralizedOrderRequest gor = gorIt.next();
            List<GeneralizedActionRequest> gars = gor.getGars();
            if (gars == null || gars.isEmpty()) continue;
            for (GeneralizedActionRequest gar : gars) {
                if (this.containsRecord(ciMap, gor, gar) || (!GeneralizedRequest.isDateValid(fixation) || gar.getStartDate() >= fixation) && !(gar.getOutOfPlanQty() > 0.0)) continue;
                completedToAdd.add(new CompletedQty(gor.getId(), gar.getAction().getName(), 0.0, 0.0));
            }
        }
        this.completedQties.addAll(completedToAdd);
    }

    private boolean containsRecord(Multimap<String, CompletedQty> reports, GeneralizedOrderRequest gor, GeneralizedActionRequest gar) {
        for (CompletedQty rep : reports.get(gor.getId())) {
            if (!gar.getAction().getName().equals(rep.getActionName())) continue;
            return true;
        }
        return false;
    }

    public void fillCompleted() {
        for (CompletedQty garCompleted : this.completedQties) {
            double completedMat;
            double completedQty;
            String actionName;
            String gorId = garCompleted.getGorId();
            GeneralizedActionRequest affectedGar = this.fillCompleted(gorId, actionName = garCompleted.getActionName(), completedQty = garCompleted.getQty(), completedMat = garCompleted.getQtyMat(), this.problems);
            if (affectedGar == null) continue;
            this.affectedGars.add(affectedGar);
        }
    }

    private GeneralizedActionRequest fillCompleted(String gorId, String actionName, double completedQty, double completedMat, List<Problem> problems) {
        double roundedCompletedMat;
        GeneralizedOrderRequest gor = this.superplan.getGor(gorId);
        if (gor == null) {
            log.debug("GOR with " + gorId + " does not exist in Plantune.");
            problems.add(Problem.createProblem2("01800", gorId));
            return null;
        }
        GeneralizedActionRequest gar = gor.getGar(actionName);
        if (gar == null) {
            Problem prob = Problem.createProblem2("01900", gorId, actionName);
            prob.logProblem(log);
            problems.add(prob);
            return null;
        }
        double roundedCompleted = gar.getAction().roundQtyWrtGranularityDown(completedQty);
        if (roundedCompleted != completedQty) {
            DecimalFormat df = new DecimalFormat("0.############");
            log.debug("Completed qty for action " + actionName + " is " + completedQty + ", but actions granularity is " + gar.getAction().getGranularity());
            problems.add(Problem.createProblem2("02000", gorId, actionName, df.format(completedQty), df.format(roundedCompleted)));
            if (roundedCompleted == 0.0) {
                return null;
            }
            completedQty = roundedCompleted;
        }
        if ((roundedCompletedMat = gar.getAction().roundQtyWrtGranularityDown(completedMat)) != completedMat) {
            DecimalFormat df = new DecimalFormat("0.############");
            log.debug("Completed mat for action " + actionName + " is " + completedMat + ", but actions granularity is " + gar.getAction().getGranularity());
            problems.add(Problem.createProblem2("02050", gorId, actionName, df.format(completedQty), df.format(roundedCompletedMat)));
            completedMat = roundedCompletedMat;
        }
        gar.setCompletedQty(completedQty);
        gar.setCompletedMat(completedMat);
        return gar;
    }

    public List<Problem> getProblems() {
        return Collections.unmodifiableList(this.problems);
    }

    public List<GeneralizedActionRequest> getAffectedGars() {
        return Collections.unmodifiableList(this.affectedGars);
    }

    public void applyCompleted(List<Tuple<GeneralizedActionRequest, Double>> deviationsList, boolean unplanDelayed) {
        Preconditions.checkArgument(this.superplan != null, "Superplan must not be null.");
        Preconditions.checkArgument(deviationsList != null, "List of GARs must not be null.");
        ArrayList<GeneralizedOrderRequest> affectedGors = Lists.newArrayList();
        HashMap<GeneralizedOrderRequest, GeneralizedActionRequest> firstReplannedMap = Maps.newHashMap();
        for (Tuple<GeneralizedActionRequest, Double> tuple : deviationsList) {
            double unplanBeginning;
            double unplanEnd;
            GeneralizedActionRequest gar = tuple.getFirst();
            Preconditions.checkArgument(gar != null, "All GARs must be non-null.");
            double dev = tuple.getSecond() != null ? tuple.getSecond() : 0.0;
            double completed = gar.getCompletedQty();
            double completedMat = gar.getCompletedMat();
            double outOfPlan = gar.getOutOfPlanQty();
            double oopDiff = completed - outOfPlan;
            double planned = gar.getPlannedQty();
            if (completed < outOfPlan + dev - 1.0E-7 || completed > planned + dev + 1.0E-7) {
                GeneralizedOrderRequest gor = ProductionTreeAlgorithms.getNearestGor(gar);
                throw new IllegalArgumentException("Deviation inconsistent with GAR data (GOR: " + (gor != null ? gor.getId() : "N/A") + "; action: " + gar.getAction().getName() + "; deviation: " + dev + "; outOfPlan: " + outOfPlan + "; completed:" + completed + "; planned:" + gar.getPlannedQty() + ")");
            }
            if (dev >= -1.0E-7) {
                unplanEnd = dev;
                unplanBeginning = completed - outOfPlan - unplanEnd;
            } else {
                unplanEnd = 0.0;
                unplanBeginning = oopDiff >= -1.0E-7 ? completed - outOfPlan : 0.0;
                if (unplanDelayed || oopDiff < -1.0E-7) {
                    int firstGarOrder;
                    GeneralizedOrderRequest gor;
                    if (unplanDelayed) {
                        unplanBeginning = oopDiff >= -1.0E-7 ? (unplanBeginning += Math.abs(dev)) : (unplanBeginning += Math.abs(dev) - Math.abs(oopDiff));
                    }
                    if (!firstReplannedMap.containsKey(gor = ProductionTreeAlgorithms.getNearestGor(gar))) {
                        firstReplannedMap.put(gor, gar);
                    }
                    GeneralizedActionRequest firstGar = (GeneralizedActionRequest)firstReplannedMap.get(gor);
                    Actiongram actgr = gor.getSelectedActiongram();
                    int garOrder = actgr.getActionOrder(gar.getAction());
                    if (garOrder < (firstGarOrder = actgr.getActionOrder(firstGar.getAction()))) {
                        firstReplannedMap.put(gor, gar);
                    }
                }
            }
            gar.setOutOfPlanQty(completed);
            gar.setOutOfPlanMat(completedMat);
            ProductionTreeAlgorithms.unplanQty(gar, unplanBeginning, ProductionTreeAlgorithms.UnplanFrom.BEGINING);
            ProductionTreeAlgorithms.unplanQty(gar, unplanEnd, ProductionTreeAlgorithms.UnplanFrom.END);
        }
        for (Map.Entry entry : firstReplannedMap.entrySet()) {
            int unplanFrom;
            GeneralizedOrderRequest gor = (GeneralizedOrderRequest)entry.getKey();
            List<GeneralizedActionRequest> gars = gor.getGars();
            for (int i = unplanFrom = gars.indexOf(entry.getValue()) + 1; i < gars.size(); ++i) {
                ProductionTreeAlgorithms.removeRelatedActivities(gars.get(i));
            }
        }
        for (GeneralizedOrderRequest generalizedOrderRequest : affectedGors) {
            StartEndQtyUpdater.updateFrom(generalizedOrderRequest);
        }
        RebuildPlannerUtils.fixAndRegister(this.superplan.getPlan());
    }

    public void applyCompleted(List<GeneralizedActionRequest> gars, long date, boolean unplanDelayed) {
        ArrayList<Tuple<GeneralizedActionRequest, Double>> deviationsList = Lists.newArrayListWithCapacity(gars.size());
        for (GeneralizedActionRequest gar : gars) {
            double dev = ProductionTreeAlgorithms.deviation(gar, date);
            deviationsList.add(Tuple.create(gar, dev));
        }
        this.applyCompleted(deviationsList, unplanDelayed);
    }

    public void applyCompleted(long date, boolean unplanDelayed) {
        this.applyCompleted(this.getAffectedGars(), date, unplanDelayed);
    }

    public void applyCompleted() {
        this.applyCompleted(System.currentTimeMillis(), true);
    }

    public static CompletedQtiesLoader applyCompleted(Superplan superplan, List<CompletedQty> completedQties) {
        CompletedQtiesLoader loader = new CompletedQtiesLoader(superplan, completedQties);
        loader.addInFixationCompleted();
        loader.fillCompleted();
        loader.applyCompleted();
        return loader;
    }

    public void applyCompletedUnplanned() {
        Set<GeneralizedOrderRequest> affectedGors = Sets.newIdentityHashSet();
        for (GeneralizedActionRequest gar : this.affectedGars) {
            gar.unsafeSetOutOfPlanQty(gar.getCompletedQty());
            gar.unsafeSetOutOfPlanMat(gar.getCompletedMat());
            GeneralizedOrderRequest gor = ProductionTreeAlgorithms.getNearestGor(gar);
            affectedGors.add(gor);
            if (!(gar.getInPlanQty() > 1.0E-7)) continue;
            throw new IllegalStateException(String.format("GAR %s:%s has some AAs.", gor.getId(), gar.getAction().getId()));
        }
        for (GeneralizedOrderRequest gor : affectedGors) {
            gor.updateSummaryData();
        }
    }
}

